<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sports Dashboard</title>
    <style>
        :root {
            --bg-color: #0b202e;
            --sidebar-color: #091d29;
            --text-color: #ffffff;
            --icon-color: #ffffff;
            --button-bg: linear-gradient(145deg, #2a5b69, #091d29);
            --button-hover-bg: linear-gradient(145deg, #2e6474, #0c2431);
            --button-active-bg: linear-gradient(145deg, #091d29, #2a5b69);
            --webview-bg-color: #0b202e;
        }

        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background-color: var(--bg-color);
            color: var(--text-color);
            display: flex;
            height: 100vh;
            overflow: hidden;
        }

        .sidebar {
            width: 145px;
            background-color: var(--sidebar-color);
            padding: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.3);
        }

        .logo {
            margin: 10px 0;
            width: 60px;
            height: 60px;
            filter: var(--icon-color);
        }

        .button-container {
            width: 100%;
            text-align: center;
            margin: 3px 0;
        }

        .button, .theme-selector {
            width: 120px;
            height: 30px;
            margin: 1px;
            border: none;
            border-radius: 12px;
            font-size: 10px;
            color: var(--text-color);
            background: var(--button-bg);
            box-shadow: 6px 6px 12px rgba(0, 0, 0, 0.4), -6px -6px 12px rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .button:hover, .theme-selector:hover {
            background: var(--button-hover-bg);
            box-shadow: 8px 8px 16px rgba(0, 0, 0, 0.5), -8px -8px 16px rgba(255, 255, 255, 0.15);
            transform: translateY(-4px);
        }

        .button:active, .theme-selector:active {
            background: var(--button-active-bg);
            box-shadow: inset 4px 4px 8px rgba(0, 0, 0, 0.4), inset -4px -4px 8px rgba(255, 255, 255, 0.1);
            transform: translateY(2px);
        }

        .button:focus, .theme-selector:focus {
            outline: none;
            box-shadow: 0 0 15px 3px #ff4d4d;
        }

        .header {
            height: 60px;
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            justify-content: space-around;
            background-color: var(--bg-color);
            padding: 0 10px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.3);
        }

        .header .button {
            width: auto;
            height: 35px;
            min-width: 80px;
            min-height: 30px;
            max-width: 150px;
            max-height: 50px;
            font-size: 10px;
            margin: 15px;
        }

        .theme-selector {
            width: auto;
            height: 35px;
            padding: 0 10px;
            font-size: 14px;
        }

        .content {
            flex-grow: 1;
            display: flex;
            flex-direction: column;
            background-color: #073d47;
            height: 100%;
            padding: 0;
            box-sizing: border-box;
            overflow: hidden;
        }

        .webviews {
            display: flex;
            flex-grow: 1;
            overflow: hidden;
        }

        .webview {
            flex-grow: 5;
            background-color: var(--webview-bg-color);
            border: none;
            overflow: hidden;
            display: none;
            height: 100%;
            width: 100%;
        }

        .webview iframe {
            width: 100%;
            height: 100%;
            border: none;
        }

        .home-page {
            flex-grow: 5;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100%;
        }

        .home-page img {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
            filter: var(--icon-color);
        }
    </style>
    <script>
        function loadContent(webviewId, url) {
            document.querySelector('.home-page').style.display = 'none';
            document.querySelectorAll('.webview').forEach(view => {
                view.style.display = 'none';
                view.querySelector('iframe').src = '';
            });
            const webview = document.getElementById(webviewId);
            webview.querySelector('iframe').src = url;
            webview.style.display = 'block';
        }

        function goHome() {
            document.querySelector('.home-page').style.display = 'flex';
            document.querySelectorAll('.webview').forEach(view => {
                view.style.display = 'none';
                view.querySelector('iframe').src = '';
            });
        }

        function changeTheme(theme) {
            let root = document.documentElement;

            switch (theme) {
                case 'light':
                    root.style.setProperty('--bg-color', '#202020');
                    root.style.setProperty('--sidebar-color', '#1F1F1F');
                    root.style.setProperty('--text-color', '#fff');
                    root.style.setProperty('--icon-color', 'invert(0%) sepia(0%) saturate(0%) hue-rotate(0deg) brightness(100%) contrast(100%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #333, #000)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #444, #111)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #000, #333)');
                    root.style.setProperty('--webview-bg-color', '#212121'); // Darker color for webview background
                    
                    break;
                case 'dark':
                    root.style.setProperty('--bg-color', '#091d29');
                    root.style.setProperty('--sidebar-color', '#091d29');
                    root.style.setProperty('--text-color', '#fff');
                    root.style.setProperty('--icon-color', 'invert(100%) sepia(0%) saturate(0%) hue-rotate(0deg) brightness(100%) contrast(100%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #2a5b69, #091d29)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #2e6474, #0c2431)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #091d29, #2a5b69)');
                    root.style.setProperty('--webview-bg-color', '#0b202e');
                    break;
                case 'blue':
                    root.style.setProperty('--bg-color', '#001f3f');
                    root.style.setProperty('--sidebar-color', '#00122a');
                    root.style.setProperty('--text-color', '#a0c4ff');
                    root.style.setProperty('--icon-color', 'invert(76%) sepia(8%) saturate(6287%) hue-rotate(204deg) brightness(95%) contrast(106%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #1a7aa7, #003f5f)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #2088b7, #004d6f)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #003f5f, #1a7aa7)');
                    root.style.setProperty('--webview-bg-color', '#003f5f');
                    break;
                case 'black':
                    root.style.setProperty('--bg-color', '#000');
                    root.style.setProperty('--sidebar-color', '#111');
                    root.style.setProperty('--text-color', '#fff');
                    root.style.setProperty('--icon-color', 'invert(100%) sepia(0%) saturate(0%) hue-rotate(0deg) brightness(100%) contrast(100%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #333, #000)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #444, #111)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #000, #333)');
                    root.style.setProperty('--webview-bg-color', '#333');
                    break;
                case 'gray':
                    root.style.setProperty('--bg-color', '#808080');
                    root.style.setProperty('--sidebar-color', '#696969');
                    root.style.setProperty('--text-color', '#fff');
                    root.style.setProperty('--icon-color', 'invert(100%) sepia(0%) saturate(0%) hue-rotate(0deg) brightness(100%) contrast(100%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #a0a0a0, #808080)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #b0b0b0, #909090)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #808080, #a0a0a0)');
                    root.style.setProperty('--webview-bg-color', '#606060');
                    break;
                case 'sky-blue':
                    root.style.setProperty('--bg-color', '#87CEEB');
                    root.style.setProperty('--sidebar-color', '#4682B4');
                    root.style.setProperty('--text-color', '#000');
                    root.style.setProperty('--icon-color', 'invert(27%) sepia(87%) saturate(2967%) hue-rotate(170deg) brightness(94%) contrast(93%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #a8e7ff, #73c8de)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #b8f7ff, #83d8ee)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #73c8de, #a8e7ff)');
                    root.style.setProperty('--webview-bg-color', '#4682B4');
                    break;
                case 'red':
                    root.style.setProperty('--bg-color', '#ff4d4d');
                    root.style.setProperty('--sidebar-color', '#b22222');
                    root.style.setProperty('--text-color', '#fff');
                    root.style.setProperty('--icon-color', 'invert(100%) sepia(0%) saturate(0%) hue-rotate(0deg) brightness(100%) contrast(100%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #ff6666, #b22222)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #ff7777, #c33333)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #b22222, #ff6666)');
                    root.style.setProperty('--webview-bg-color', '#b22222');
                    break;
                case 'green':
                    root.style.setProperty('--bg-color', '#4CAF50');
                    root.style.setProperty('--sidebar-color', '#2E8B57');
                    root.style.setProperty('--text-color', '#fff');
                    root.style.setProperty('--icon-color', 'invert(69%) sepia(74%) saturate(1168%) hue-rotate(85deg) brightness(88%) contrast(84%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #5bdc5f, #2e8b57)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #6cec6f, #3f9b67)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #2e8b57, #5bdc5f)');
                    root.style.setProperty('--webview-bg-color', '#2E8B57');
                    break;
                case 'yellow':
                    root.style.setProperty('--bg-color', '#FFD700');
                    root.style.setProperty('--sidebar-color', '#FFA500');
                    root.style.setProperty('--text-color', '#000');
                    root.style.setProperty('--icon-color', 'invert(79%) sepia(49%) saturate(479%) hue-rotate(349deg) brightness(102%) contrast(104%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #ffdf4d, #bfa300)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #ffef5d, #cfb310)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #bfa300, #ffdf4d)');
                    root.style.setProperty('--webview-bg-color', '#bfa300');
                    break;
                case 'purple':
                    root.style.setProperty('--bg-color', '#800080');
                    root.style.setProperty('--sidebar-color', '#4B0082');
                    root.style.setProperty('--text-color', '#fff');
                    root.style.setProperty('--icon-color', 'invert(29%) sepia(72%) saturate(7444%) hue-rotate(261deg) brightness(77%) contrast(106%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #993299, #4b0082)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #aa44aa, #5c1193)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #4b0082, #993299)');
                    root.style.setProperty('--webview-bg-color', '#4B0082');
                    break;
                case 'pink':
                    root.style.setProperty('--bg-color', '#FFC0CB');
                    root.style.setProperty('--sidebar-color', '#FF69B4');
                    root.style.setProperty('--text-color', '#000');
                    root.style.setProperty('--icon-color', 'invert(46%) sepia(55%) saturate(5679%) hue-rotate(309deg) brightness(98%) contrast(105%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #ffd0db, #ff69b4)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #ffe0eb, #ff79c4)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #ff69b4, #ffd0db)');
                    root.style.setProperty('--webview-bg-color', '#ff69b4');
                    break;
                case 'gold':
                    root.style.setProperty('--bg-color', '#FFD700');
                    root.style.setProperty('--sidebar-color', '#DAA520');
                    root.style.setProperty('--text-color', '#000');
                    root.style.setProperty('--icon-color', 'invert(79%) sepia(49%) saturate(479%) hue-rotate(349deg) brightness(102%) contrast(104%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #ffd700, #daa520)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #ffef5d, #cfb310)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #bfa300, #ffd700)');
                    root.style.setProperty('--webview-bg-color', '#daa520');
                    break;
                case 'silver':
                    root.style.setProperty('--bg-color', '#C0C0C0');
                    root.style.setProperty('--sidebar-color', '#A9A9A9');
                    root.style.setProperty('--text-color', '#000');
                    root.style.setProperty('--icon-color', 'invert(46%) sepia(55%) saturate(5679%) hue-rotate(309deg) brightness(98%) contrast(105%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #dcdcdc, #a9a9a9)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #e0e0e0, #b5b5b5)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #a5a5a5, #dcdcdc)');
                    root.style.setProperty('--webview-bg-color', '#a9a9a9');
                    break;
                case 'bronze':
                    root.style.setProperty('--bg-color', '#CD7F32');
                    root.style.setProperty('--sidebar-color', '#8C7853');
                    root.style.setProperty('--text-color', '#fff');
                    root.style.setProperty('--icon-color', 'invert(46%) sepia(55%) saturate(5679%) hue-rotate(309deg) brightness(98%) contrast(105%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #e0a776, #8c7853)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #e5ab7c, #8c7853)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #8c7853, #e0a776)');
                    root.style.setProperty('--webview-bg-color', '#8C7853');
                    break;
                case 'teal':
                    root.style.setProperty('--bg-color', '#008080');
                    root.style.setProperty('--sidebar-color', '#006666');
                    root.style.setProperty('--text-color', '#fff');
                    root.style.setProperty('--icon-color', 'invert(29%) sepia(72%) saturate(7444%) hue-rotate(261deg) brightness(77%) contrast(106%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #009999, #006666)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #00aaaa, #006666)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #006666, #009999)');
                    root.style.setProperty('--webview-bg-color', '#006666');
                    break;
                case 'indigo':
                    root.style.setProperty('--bg-color', '#4B0082');
                    root.style.setProperty('--sidebar-color', '#2E0854');
                    root.style.setProperty('--text-color', '#fff');
                    root.style.setProperty('--icon-color', 'invert(46%) sepia(55%) saturate(5679%) hue-rotate(309deg) brightness(98%) contrast(105%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #4b0082, #2e0854)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #551A8B, #4b0082)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #4b0082, #2e0854)');
                    root.style.setProperty('--webview-bg-color', '#2e0854');
                    break;
                case 'mint':
                    root.style.setProperty('--bg-color', '#98FF98');
                    root.style.setProperty('--sidebar-color', '#32CD32');
                    root.style.setProperty('--text-color', '#000');
                    root.style.setProperty('--icon-color', 'invert(46%) sepia(55%) saturate(5679%) hue-rotate(309deg) brightness(98%) contrast(105%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #afffaf, #32cd32)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #baffba, #3ded3d)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #32cd32, #afffaf)');
                    root.style.setProperty('--webview-bg-color', '#32CD32');
                    break;
                case 'lavender':
                    root.style.setProperty('--bg-color', '#E6E6FA');
                    root.style.setProperty('--sidebar-color', '#CCCCFF');
                    root.style.setProperty('--text-color', '#000');
                    root.style.setProperty('--icon-color', 'invert(46%) sepia(55%) saturate(5679%) hue-rotate(309deg) brightness(98%) contrast(105%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #f0f0ff, #ccccff)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #e8e8ff, #d5d5ff)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #ccccff, #f0f0ff)');
                    root.style.setProperty('--webview-bg-color', '#ccccff');
                    break;
                case 'navy':
                    root.style.setProperty('--bg-color', '#000080');
                    root.style.setProperty('--sidebar-color', '#000044');
                    root.style.setProperty('--text-color', '#ffffff');
                    root.style.setProperty('--icon-color', 'invert(100%) sepia(0%) saturate(0%) hue-rotate(0deg) brightness(100%) contrast(100%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #0000ff, #000080)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #0000ee, #000077)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #000080, #0000ff)');
                    root.style.setProperty('--webview-bg-color', '#000044');
                    break;
                case 'beige':
                    root.style.setProperty('--bg-color', '#F5F5DC');
                    root.style.setProperty('--sidebar-color', '#D2B48C');
                    root.style.setProperty('--text-color', '#000000');
                    root.style.setProperty('--icon-color', 'invert(0%) sepia(0%) saturate(0%) hue-rotate(0deg) brightness(100%) contrast(100%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #F5DEB3, #F5F5DC)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #E6E6E3, #D2B48C)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #D2B48C, #F5DEB3)');
                    root.style.setProperty('--webview-bg-color', '#D2B48C');
                    break;
                case 'coral':
                    root.style.setProperty('--bg-color', '#FF7F50');
                    root.style.setProperty('--sidebar-color', '#FF6347');
                    root.style.setProperty('--text-color', '#ffffff');
                    root.style.setProperty('--icon-color', 'invert(100%) sepia(0%) saturate(0%) hue-rotate(0deg) brightness(100%) contrast(100%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #FF4500, #FF6347)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #FF6347, #FF7F50)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #FF4500, #FF6347)');
                    root.style.setProperty('--webview-bg-color', '#FF6347');
                    break;
                case 'peach':
                    root.style.setProperty('--bg-color', '#FFDAB9');
                    root.style.setProperty('--sidebar-color', '#FFCBA4');
                    root.style.setProperty('--text-color', '#000000');
                    root.style.setProperty('--icon-color', 'invert(0%) sepia(0%) saturate(0%) hue-rotate(0deg) brightness(100%) contrast(100%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #FFDAB9, #FFCBA4)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #FFE4B5, #FFDEAD)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #FFCBA4, #FFDAB9)');
                    root.style.setProperty('--webview-bg-color', '#FFCBA4');
                    break;
                case 'chocolate':
                    root.style.setProperty('--bg-color', '#D2691E');
                    root.style.setProperty('--sidebar-color', '#8B4513');
                    root.style.setProperty('--text-color', '#ffffff');
                    root.style.setProperty('--icon-color', 'invert(100%) sepia(0%) saturate(0%) hue-rotate(0deg) brightness(100%) contrast(100%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #8B4513, #A0522D)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #A0522D, #D2691E)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #8B4513, #A0522D)');
                    root.style.setProperty('--webview-bg-color', '#8B4513');
                    break;
                default:
                    root.style.setProperty('--bg-color', '#0b202e');
                    root.style.setProperty('--sidebar-color', '#091d29');
                    root.style.setProperty('--text-color', '#fff');
                    root.style.setProperty('--icon-color', 'invert(100%) sepia(0%) saturate(0%) hue-rotate(0deg) brightness(100%) contrast(100%)');
                    root.style.setProperty('--button-bg', 'linear-gradient(145deg, #2a5b69, #091d29)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(145deg, #2e6474, #0c2431)');
                    root.style.setProperty('--button-active-bg', 'linear-gradient(145deg, #091d29, #2a5b69)');
                    root.style.setProperty('--webview-bg-color', '#091d29');
                    break;
            }

            document.body.style.backgroundColor = `var(--bg-color)`;
            document.querySelector('.sidebar').style.backgroundColor = `var(--sidebar-color)`;
            document.querySelector('.header').style.backgroundColor = `var(--bg-color)`;
            document.querySelectorAll('.button, .theme-selector').forEach(button => {
                button.style.color = `var(--text-color)`;
                button.style.background = `var(--button-bg)`;
            });
            document.querySelectorAll('.webview').forEach(webview => {
                webview.style.backgroundColor = `var(--webview-bg-color)`;
            });
            document.querySelectorAll('.logo, .home-page img').forEach(icon => {
                icon.style.filter = `var(--icon-color)`;
            });
        }

        document.addEventListener('keydown', function(e) {
            const content = document.querySelector('.content');
            const step = 30;
            
            switch (e.key) {
                case 'ArrowUp':
                    content.scrollBy(0, -step);
                    break;
                case 'ArrowDown':
                    content.scrollBy(0, step);
                    break;
                case 'PageUp':
                    content.scrollBy(0, -content.clientHeight);
                    break;
                case 'PageDown':
                    content.scrollBy(0, content.clientHeight);
                    break;
                case 'Home':
                    content.scrollTo(0, 0);
                    break;
                case 'End':
                    content.scrollTo(0, content.scrollHeight);
                    break;
            }
        });

        window.onload = function() {
            loadContent('mainWebview', 'leagues.php');
            changeTheme('light');  // Default theme
        };
    </script>
</head>
<body>
    
<?php
include(__DIR__ . '/../includes/functions.php');
global $db; 
$res = $db->select('leaguestable', '*', '', '');
$mes = $db->select('exsport', '*', 'id = :id', '', [':id' => 1]);

$extra_name = $mes[0]['name'] ?? '';  
$extra_link = $mes[0]['link'] ?? '';

if (!empty($res)) {
    echo '<div class="sidebar">';
    echo '<img class="logo" src="logo_sport.png" alt="Logo">';
    
    foreach ($res as $index => $row) {
        $league = htmlspecialchars($row['league']);
        $leagueId = htmlspecialchars($row['leagueId']);
        echo '<div class="button-container" onclick="loadContent(\'mainWebview\', \'' . 'sport_l_table_single.php?id='.$leagueId .'&name='.$league. '\')">';
        echo '<button class="button">' . $league . '</button>';
        echo '</div>';
    }
    
    echo '</div>';
}

$db->close();
?>


    <div class="content">
        <div class="header">
            <button class="button" onclick="loadContent('mainWebview','pl_buttons.php')">LEAGUES SLIDER</button>
            <button class="button" onclick="loadContent('mainWebview','leagues.php')">ALL LEAGUES</button>
            <button class="button" onclick="loadContent('mainWebview','sport_top.php')">TOP LIVE</button>
            <button class="button" onclick="loadContent('mainWebview','sport_tv_today.php')">TV SPORT</button>
            <button class="button" onclick="loadContent('mainWebview','sport.php')">TV GUIDE</button>
            
            <?php if (!empty($extra_link) && !empty($extra_name)): ?>
                <button class="button" onclick="loadContent('mainWebview','<?php echo $extra_link; ?>')">
                    <?php echo $extra_name; ?>
                </button>
            <?php endif; ?>
            <select class="theme-selector" onchange="changeTheme(this.value)">
                <option value="light">Sparkle Theme</option>
                <option value="dark">Dark Theme</option>
                <option value="blue">Blue Theme</option>
                <option value="black">Black Theme</option>
                <option value="gray">Gray Theme</option>
                <option value="sky-blue">Sky Blue Theme</option>
                <option value="red">Red Theme</option>
                <option value="green">Green Theme</option>
                <option value="yellow">Yellow Theme</option>
                <option value="purple">Purple Theme</option>
                <option value="pink">Pink Theme</option>
                <option value="orange">Orange Theme</option>
                <option value="gold">Gold Theme</option>
                <option value="silver">Silver Theme</option>
                <option value="bronze">Bronze Theme</option>
                <option value="teal">Teal Theme</option>
                <option value="indigo">Indigo Theme</option>
                <option value="mint">Mint Theme</option>
                <option value="lavender">Lavender Theme</option>
                <option value="navy">Navy Theme</option>
                <option value="beige">Beige Theme</option>
                <option value="coral">Coral Theme</option>
                <option value="peach">Peach Theme</option>
                <option value="chocolate">Chocolate Theme</option>
            </select>
        </div>
        
        <div class="webviews">
            <div class="home-page" style="display: none;">
                <img src="https://yoururlhere/APPLOGO/apkwizard.png" alt="Splash Image">
            </div>
            <div class="webview" id="mainWebview"><iframe src=""></iframe></div>
        </div>
    </div>
</body>

</html>