<?php
ini_set('display_errors', 0);
include(__DIR__ . '/functions.php');
$adb = new SQLite3('./api/.adb.db');
$adb3 = new SQLite3('./api/.db_logo.db');
$adb4 = new SQLite3('./api/.db_bg.db'); 

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$log_check = $db->select('user', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if (!isset($_SESSION['name']) == $loggedinuser) {
    header("location:"."index.php");
    exit();
}

if (isset($_REQUEST['logout'])) {
    session_destroy();
    setcookie("auth", "");
    header("Location: index.php");
    exit;
}

$time = $_SERVER['REQUEST_TIME'];

$timeout_duration = 900;
if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY']) > $timeout_duration) {
    session_unset();
    session_destroy();
    session_start();
}
$_SESSION['LAST_ACTIVITY'] = $time;

function sanitize($data) {
    $data = trim($data);
    $data = htmlspecialchars($data, ENT_QUOTES );
    $data = SQLite3::escapeString($data);
    return $data;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Max Rebrands Panels Sm V2</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="RTX">
    <link rel="icon" type="image/x-icon" href="./img/favicon.ico">
    <link rel="apple-touch-icon" sizes="180x180" href="./img/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="./img/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./img/favicon-16x16.png">
    <link rel="manifest" href="./img/site.webmanifest">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
    <link href="css/themes/darkly/bootstrap.css" rel="stylesheet" title="main">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.2.3/animate.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        body {
            background-color: #181828;
            background-image: url("./img/binding_dark.webp");
            color: #fff;
            min-height: 100vh;
        }

        #net-canvas {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
        }

        .header-bar {
            background-color: #1a1a30;
            padding: 10px 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
        }

        .logo-area {
            display: flex;
            align-items: center;
        }

        .logo-area img {
            height: 40px;
            margin-right: 15px;
        }

        .brand-title {
            color: white;
            font-size: 20px;
            font-weight: bold;
            margin: 0;
            letter-spacing: 1px;
            text-transform: uppercase;
        }

        .logout-button {
            background-color: #dc3545;
            color: white;
            border: none;
            border-radius: 4px;
            padding: 6px 12px;
            font-size: 14px;
            cursor: pointer;
        }

        .logout-button:hover {
            background-color: #c82333;
        }

        .navigation-bar {
            background-color: rgba(30, 30, 60, 0.5);
            padding: 10px 20px;
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            margin-top: 20px;
            border-radius: 8px;
        }

        .nav-button {
            background-color: #6610f2;
            color: white;
            border: none;
            border-radius: 4px;
            padding: 8px 15px;
            margin: 5px;
            display: flex;
            align-items: center;
            font-size: 14px;
            cursor: pointer;
            text-decoration: none;
        }

        .nav-button:hover {
            background-color: #520dc2;
            color: white;
            text-decoration: none;
        }

        .nav-button i {
            margin-right: 8px;
        }

        .dropdown-menu {
            background-color: #2c2c50;
            border: none;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            padding: 0;
            margin-top: 5px;
        }

        .dropdown-item {
            color: white;
            padding: 10px 15px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .dropdown-item:last-child {
            border-bottom: none;
        }

        .dropdown-item:hover {
            background-color: #6610f2;
            color: white;
        }

        #pageMessages {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            top: 15px;
            width: 60%;
            z-index: 9999;
            text-align: center;
        }
    </style>
</head>

<body>
    <div id="net-canvas"></div>

    <!-- Encabezado con logo y botón de logout -->
    <div class="header-bar">
        <div class="logo-area">
            <img src="./img/login_logo.png" alt="Logo">
            <h1 class="brand-title">Smarters V2 Pro 2025 - P2PLAY APPS</h1>
        </div>
        <a href="<?=basename($_SERVER["SCRIPT_NAME"]).'?logout'?>" class="logout-button">
            <i class="fa fa-sign-out"></i> Logout
        </a>
    </div>

    <div class="container">
        <!-- Área de mensajes -->
        <div id="pageMessages"></div>

        <!-- Barra de navegación horizontal -->
        <div class="navigation-bar">
            <a href="main.php" class="nav-button">
                <i class="fa fa-cogs"></i> Registrar DNS
            </a>
            <a href="logo.php" class="nav-button">
                <i class="fa fa-comment"></i> LogoTipo
            </a>
            <a href="bg.php" class="nav-button">
                <i class="fa fa-comment"></i> Background
            </a>
            <a href="nomeapk.php" class="nav-button">
                <i class="fa fa-comment"></i> Mensagem [Mobile]
            </a>
               <a href="welcome.php" class="nav-button">
                <i class="fa fa-comment"></i> Mensagem [Box's]
            </a>
             </a>
               <a href="note.php" class="nav-button">
                <i class="fa fa-comment"></i> Mensagem Login
            </a>
            <a href="mRTXBGVideo.php" class="nav-button">
                <i class="fa fa-file-movie-o"></i> Intro
            </a>
            
            <a href="user.php" class="nav-button">
                <i class="fa fa-user"></i> Perfil
            </a>
        </div>

        <div class="container-fluid mt-4">
            <!-- Aquí va el contenido específico de cada página -->
            <?php 
            // El contenido se cargará dinámicamente según la página
            ?>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script>
    <script src="./js/custom.js"></script>
    <script src="./js/three.min.js"></script>
    <script src="./js/vanta.net.min.js"></script>

    <script>
    $(document).ready(function() {
        // Inicializa el fondo con efecto de red
        if (typeof VANTA !== 'undefined' && VANTA.NET) {
            VANTA.NET({
                el: "#net-canvas",
                mouseControls: true,
                touchControls: true,
                gyroControls: false,
                minHeight: 200.00,
                minWidth: 200.00,
                scale: 1.00,
                scaleMobile: 1.00,
                color: 0x8000FF,
                backgroundColor: 0x181828,
                points: 10.00,
                maxDistance: 20.00,
                spacing: 15.00
            });
        }
        
        // Asegura que los dropdowns funcionen
        $('.dropdown-toggle').dropdown();
    });
    </script>
</body>
</html>